#include <bits/stdc++.h>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>

const int MEM_SIZE = 1e8;
char MEM[MEM_SIZE];
int MEM_POS = 0;
void* operator new(size_t n) {
    assert(MEM_POS + n < MEM_SIZE);
    MEM_POS += n;
    return MEM + MEM_POS - n;
}
void operator delete(void* p) {}
void operator delete(void* p, size_t n) {}

using namespace std;
using ll = long long;
using ld = long double;

ofstream debug;

template <typename T, typename CMP = less<T>>
using ordered_set =__gnu_pbds::tree<T,
        __gnu_pbds::null_type,
        CMP,
        __gnu_pbds::rb_tree_tag,
        __gnu_pbds::tree_order_statistics_node_update>;

template <typename T>
struct Vector {
    T x, y;
    Vector(T x, T y): x(x), y(y) {}
    Vector(): Vector(0, 0) {}
};

template <typename T>
Vector<T> operator+(Vector<T> a, Vector<T> b) {
    return {a.x + b.x, a.y + b.y};
}
template <typename T>
Vector<T> operator-(Vector<T> a, Vector<T> b) {
    return {a.x - b.x, a.y - b.y};
}
template <typename T>
Vector<T> operator-(Vector<T> a) {
    return {-a.x, -a.y};
}
template <typename T>
Vector<T> operator*(Vector<T> a, T k) {
    return {a.x * k, a.y * k};
}
template <typename T>
Vector<T> operator*(T k, Vector<T> a) {
    return {a.x * k, a.y * k};
}
template <typename T>
Vector<T> operator/(Vector<T> a, T k) {
    return {a.x / k, a.y / k};
}
template <typename T>
T operator*(Vector<T> a, Vector<T> b) {
    return a.x * b.x + a.y * b.y;
}
template <typename T>
T operator%(Vector<T> a, Vector<T> b) {
    return a.x * b.y - a.y * b.x;
}

const ll MOD = 998244353;

struct residue {
    ll value;
    residue(): value(0) {}
    residue(ll x): value(x) {
        if (value < 0 || MOD <= value) {
            value %= MOD;
            if (value < 0) value += MOD;
        }
    }
};

residue operator+(residue a, residue b) {
    ll c = a.value + b.value;
    if (c >= MOD) c-= MOD;
    return {c};
}
residue operator-(residue a, residue b) {
    ll c = a.value - b.value;
    if (c < 0) c += MOD;
    return {c};
}
residue operator*(residue a, residue b) {
    ll c = a.value * b.value;
    if (c >= MOD) c %= MOD;
    return {c};
}

bool operator==(residue a, residue b) {
    return a.value == b.value;
}

bool operator!=(residue a, residue b) {
    return !(a == b);
}

tuple<ll, ll, ll> gcd_ext(ll a, ll b) {
    if (b == 0) return {1, 0, a};
    auto [x0, y0, d] = gcd_ext(b, a%b);
    ll x = y0;
    ll y = x0 - (a/b) * y0;
    assert(a * x + b * y == d);
    return {x, y, d};
}

residue fast_pow(residue a, int p) {
    if (p == 0) return {1};
    if (p == 1) return a;
    return fast_pow(a*a, p/2) * fast_pow(a, p%2);
}

vector<int> cur;
ll answer = 0;
void check() {
    int best = 0;
    int current = 0;
    int last = -1;
    for (int i: cur) {
        if (i == last) current++;
        else {
            last = i, current = 1;
        }
        if (current > best) best = current;
    }
    answer += best;
}

void gen(int n, int k) {
    if (n == cur.size()) {
        check();
        return;
    }
    for (int i = 1; i <= k; i++) {
        cur.push_back(i);
        gen(n, k);
        cur.pop_back();
    }
}

int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
    debug.open("debug.txt");
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int t;
    cin >> t;
    vector<vector<residue>> dp;
    vector<vector<residue>> pref;
    while (t--) {
        int n;
        ll ml;
        cin >> n >> ml;
        residue m(ml);
        dp.resize(n+1, vector<residue>(n+1, 0));
        pref.resize(n+1, vector<residue>(n+1, 0));
        dp[1][1] = m;
        pref[1][1] = m;
        for (int k = 1; k <= n; k++) {
            for (int i = 1; i <=n; i++) {
                if (i == 1 && k == 1) continue;
                if (k < i) {
                    pref[i][k] = pref[i-1][k] + pref[i][k-1] - pref[i-1][k-1];
                    continue;
                }
                if (i == 1) {
                    dp[i][k] = dp[i][k-1] * (m-1);
                    pref[i][k] = dp[i][k] + pref[i-1][k] + pref[i][k-1] - pref[i-1][k-1];
                    continue;
                }
                if (i == k) {
                    dp[i][k] = dp[i-1][k-1];
                    pref[i][k] = dp[i][k] + pref[i-1][k] + pref[i][k-1] - pref[i-1][k-1];
                    continue;
                }
                dp[i][k] = pref[i][k-1] - pref[i-1][k-1] - pref[i][k-i] + pref[i-1][k-i];
                dp[i][k] = dp[i][k] + pref[i][k-i] - pref[i][k-i-1];
                dp[i][k] = dp[i][k] * (m-1);
                pref[i][k] = dp[i][k] + pref[i-1][k] + pref[i][k-1] - pref[i-1][k-1];
            }
        }
        residue answer = 0;
        for (int i = 1; i <= n; i++) {
            answer = answer + dp[i][n] * i;
            debug << dp[i][n].value << "\n";
        }
        debug << "\n";
        auto [x, y, d] = gcd_ext(m.value, MOD);
        if (x < 0) {
            x %= MOD;
            if (x < 0) x += MOD;
        }
        residue power = fast_pow(x, n);
        cout << (power * answer).value << "\n";
        dp.clear();
        pref.clear();
    }
    return 0;
}